import pandas as pd
import tkinter as tk
from tkinter import filedialog
from pathlib import Path

# --- GUI Setup ---
root = tk.Tk()
root.withdraw()  # Hide the main Tk window

# Ask user to select a CSV file
csv_path = filedialog.askopenfilename(
    title="Select CSV file",
    filetypes=[("CSV files", "*.csv")],
)

if not csv_path:
    print("No file selected.")
    exit()

# --- Load CSV into DataFrame ---
df = pd.read_csv(csv_path)

# Print the number of rows and columns
print(f"Rows: {df.shape[0]}, Columns: {df.shape[1]}")

print("Column names:")
print(df.columns.tolist())

# Optional: Combine Date and Time columns into a single Datetime column
#df['Datetime'] = pd.to_datetime(df['Date'] + ' ' + df['Time'])

# Optional: Drop original columns if no longer needed
# df.drop(columns=['Date', 'Time'], inplace=True)

# --- Save DataFrame as Pickle ---
csv_file = Path(csv_path)
pkl_path = csv_file.with_suffix('.pkl')  # Replace .csv with .pkl

df.to_pickle(pkl_path)
print(f"Data saved to: {pkl_path}")
